#!/bin/bash

cd /sbox/proj/Wei/BAC

export CUDA_VISIBLE_DEVICES=1
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cuda-8.0/lib64
export AMBEREXE=/sbox/amber16/bin
export MPIRUN=/usr/lib64/openmpi-1.10/bin/mpirun
ulimit -s unlimited

nohup $MPIRUN -np 4 $AMBEREXE/sander.MPI -O -i mdtgt_vac.in -c vm1_complex_ini.crd -p vm1_complex.top \
              -ref vm1_complex_target.inpcrd -r mdtgt_run0.rst \
              -x mdtgt_run0.mdcrd -o mdtgt_run0.out -inf mdtgt_run0.mdinfo

$AMBERHOME/bin/cpptraj vm1_complex.top <<EOF
trajin mdtgt_run0.mdcrd
trajout mdtgt_run0.trj.pdb.gz dumpq
go
EOF
