#!/bin/bash

cd /sbox/proj/Wei/BAC

export CUDA_VISIBLE_DEVICES=1
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cuda-8.0/lib64
export AMBEREXE=/sbox/amber16/bin
export MPIRUN=/usr/lib64/openmpi-1.10/bin/mpirun
ulimit -s unlimited

nohup $MPIRUN -np 4 $AMBEREXE/sander.MPI -O -i mdtgt_vac-outw_wt.in \
              -p $1.top -c $1.min.rst \
              -r $1.tMD-outw_wt.ncrst -o $1.tMD-outw_wt.out \
              -ref $1.min.rst \
              -x $1.tMD-outw_wt.nc  -inf $1.tMD-outw_wt.mdinfo

$AMBERHOME/bin/cpptraj $1.top <<EOF
trajin $1.tMD-outw_wt.nc
reference $1.crd [ini]
rms ref [ini] :2-159@CA :2-159@CA  
trajout $1.tMD-outw_wt.trj.pdb.gz dumpq
go
EOF
