#!/bin/bash

cd /sbox/proj/Wei/BAC

export CUDA_VISIBLE_DEVICES=1
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cuda-8.0/lib64
export AMBEREXE=/sbox/amber16/bin
export MPIRUN=/usr/lib64/openmpi-1.10/bin/mpirun
ulimit -s unlimited

nohup $MPIRUN -np 4 $AMBEREXE/sander.MPI -O -i mdtgt_vac-inw.in \
              -p $1.top -c EcDHFR.NDP.MTXout.crd \
              -r $1.tMD-inw.ncrst -o $1.tMD-inw.out \
              -ref $1.min.rst \
              -x $1.tMD-inw.nc  -inf $1.tMD-inw.mdinfo

$AMBERHOME/bin/cpptraj $1.top <<EOF
trajin $1.tMD-inw.nc
reference $1.crd [ini]
rms ref [ini] :2-159@CA :2-159@CA  
trajout $1.tMD-inw.trj.pdb.gz dumpq
go
EOF
