#!/bin/bash

#Si la molécula está en formato pdb
#antechamber -fi pdb -i $1.pdb -fo mol2 -o $1.tmp.mol2 -nc $2 -c bcc -pf y -rn $3
#Si la molécula está en formato mol2
antechamber -i $1.mol2 -fi mol2 -o tmp.$1.pdb -fo pdb -c bcc -nc $2 -rn $3 -rf $1 -pf y 
#Conseguir un fichero mol2 con la geometría optimizada y cargas atómicas
antechamber -fi pdb -i sqm.pdb -fo mol2 -o $1.sqm.mol2 -c bcc -nc $2 -rn $3 -rf $1 -pf y
#Fichero pdb con la geometría optimizada
mv -f sqm.pdb $1.sqm.pdb
#Obtener archivos prepi y frcmod
antechamber -fi mol2 -i $1.sqm.mol2 -fo prepi -o $1.prep -at gaff -pf y
parmchk2 -f prepi -i $1.prep -o $1.frcmod
