#!/bin/bash

#ligand with charge = 0
for n in 216 XK2 DMP DMQ XV6 146
do
#Geometry optimization and poimt charge derivation
antechamber -i $n.mol2 -fi mol2 -o tmp.$n.pdb -fo pdb -c bcc -nc 0 -rn $n -rf $n -pf y 
antechamber -i sqm.pdb -fi pdb -o $n.sqm.mol2 -fo mol2 -c bcc -nc 0 -rn $n -rf $n -pf y
#Create prepi and frcmod files
antechamber -i $n.sqm.mol2 -fi mol2 -o $n.prep -fo prepi -at gaff -pf y
parmchk2 -f prepi -i $n.prep -o $n.frcmod
#Create PDB file with optimized geometry
mv -f sqm.pdb $n.sqm.pdb
done



