#!/bin/bash -e

#cd /home/farmamol/fgago/Cov2

#export CUDA_VISIBLE_DEVICES=3
#export LD_LIBRARY_PATH="/usr/local/cuda-10.1//lib:${LD_LIBRARY_PATH}"
#export AMBEREXE=/home/farmamol/amber18/bin
#ulimit -s unlimited

export AMBERHOME=/home/aperona/Software/amber16
#export PMEMD=/home/aperona/Software/amber16/bin/pmemd
export PMEMD=/home/aperona/Software/amber16/bin/pmemd.cuda
export SANDER=/home/aperona/Software/amber16/bin/sander
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$AMBERHOME/lib
export CUDA_HOME=/usr/local/cuda
source $AMBERHOME/amber.sh
export  cpptraj=~/Software/amber16/bin/cpptraj

# /usr/license/amber/amber16/amber.sh
# /usr/license/intel/impi_latest/intel64/bin/mpivars.sh
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cuda-10.0/lib64

#indir=/home/aperona/Escritorio/LdNDT/indir
#workdir=/home/aperona/Escritorio/LdNDT/wt_1md



$PMEMD -O -i min1.in -o $1.m1.out -p $1.top -r $1.m1.ncrst -c $1.crd -ref $1.crd
$PMEMD -O -i min2.in -o $1.m2.out -p $1.top -r $1.m2.ncrst -c $1.m1.ncrst -ref $1.m1.ncrst
$PMEMD -O -i min3.in -o $1.m3.out -p $1.top -r $1.m3.ncrst -c $1.m2.ncrst -ref $1.m2.ncrst
$PMEMD -O -i min.in -o $1.min.out -p $1.top -r $1.min.ncrst -c $1.m3.ncrst
#
$PMEMD -O -i h.in -o $1.h.out -p $1.top -r $1.h.ncrst -c $1.min.ncrst -x $1.h.nc -ref $1.min.ncrst
#
$PMEMD -O -i eq1.in -o $1.eq1.out -p $1.top -r $1.eq1.ncrst -c $1.h.ncrst -x $1.eq1.nc -ref $1.min.ncrst
$PMEMD -O -i eq2.in -o $1.eq2.out -p $1.top -r $1.eq2.ncrst -c $1.eq1.ncrst -x $1.eq2.nc -ref $1.min.ncrst
$PMEMD -O -i eq3.in -o $1.eq3.out -p $1.top -r $1.eq3.ncrst -c $1.eq2.ncrst -x $1.eq3.nc -ref $1.min.ncrst
$PMEMD -O -i eq4.in -o $1.eq4.out -p $1.top -r $1.eq4.ncrst -c $1.eq3.ncrst -x $1.eq4.nc -ref $1.min.ncrst
$PMEMD -O -i eq5.in -o $1.eq5.out -p $1.top -r $1.eq5.ncrst -c $1.eq4.ncrst -x $1.eq5.nc -ref $1.min.ncrst

$cpptraj $1.top <<EOF
trajin $1.eq5.ncrst
autoimage :307 
center :1-306 origin
trajout $1.eq5.orig.ncrst restartnc
go
EOF

ln -sf $1.eq5.orig.ncrst $1.md0.ncrst

#$AMBERHOME/bin/PMEMD -O -i mdRST.in       -o $1.mdRST.out -p $1.top -c $1.eq5.ncrst \
#                                  -r $1.mdRST.ncrst -x $1.mdRST.nc  -ref $1.eq5.ncrst -inf $1.mdRST.mdinfo
#ln -sf $1.mdRST.ncrst $1.md0.ncrst
 
for i in {1..10..1}; do
echo run $i
j=$((i-1))
$PMEMD -O -i mdunrestr.in    -o $1.md${i}.out -p $1.top         -c $1.md${j}.ncrst \
                             -r $1.md${i}.ncrst -x $1.md${i}.nc  -ref $1.eq5.ncrst -inf $1.md${i}.mdinfo
$cpptraj $1.top <<EOF
trajin $1.md${i}.ncrst
autoimage :307 
reference $1.crd [ini]
rms ref [ini] :1-198@CA :1-198@CA
strip :Na+|:1-306@H=
#To keep the 30 WAT closest to ligand
closest 30 :307 first noimage outprefix closest
trajout $1.md${i}.pdb.gz dumpq
go
EOF

done
./cool.unrestr.1.sh $1
